/***************************************************************************
                          AlphaBetaWithQSearch.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# include "Algorithms/AlphaBetaWithQSearch.h"
# include "Algorithms/QuiescenceSearch.h"
# include "Game/Game.h"
using namespace Alice;
/** Constructor
	*/
AlphaBetaWithQSearch::AlphaBetaWithQSearch(Game& pgame):
  AlphaBeta(pgame),
  eval(new Evaluation),
  qsearch(new QuiescenceSearch(game(), getEvaluation()))
{
  // std::cerr<<"starting eval"<<std::endl;
  eval->startObserving(&game());
};

/** Destructor
	*/
AlphaBetaWithQSearch::~AlphaBetaWithQSearch()
{
  eval->stopObserving();
  delete qsearch;
};

AlphaBeta::Score
AlphaBetaWithQSearch::staticEvaluation(Score alpha, Score beta)
{
  return qsearch->recursiveSearch(100, alpha,beta);
};
	  
void
AlphaBetaWithQSearch::presearch()
{
};

void
AlphaBetaWithQSearch::setEvaluation(Evaluation* ev)
{
  if (eval)
    {
      eval->stopObserving();
      delete eval;
    }
  eval = ev;
  eval->startObserving(&game());
  qsearch->setEvaluation(eval);
};

Evaluation*
AlphaBetaWithQSearch::getEvaluation() const
{
  return eval;
};

void
AlphaBetaWithQSearch::setGame(Game& g)
{
  eval->stopObserving();
  AlphaBeta::setGame(g);
  qsearch->setGame(g);
  eval->startObserving(&game());
};
