// -*- c++ -*-

# ifndef XBoardInterface_h
# define XBoardInterface_h
# include <iosfwd>
# include <Moves/Move.h>
# include <SmartPointer.h>
# include <XBoard/XBoardBase.h>
# include <Color.h>
# include <stack>
# include <Game/Evaluation.h>
namespace Alice
{
  class Game;
  class HashedAlphaBeta;
  class Evaluation;
  class GameRecord;
  //! Classes that deal with the GUI xboard 
  namespace XBoard
  {
    class XBoardFeature;
    class XBoardInterface
      : public XBoardBase
    {
    public:
      XBoardInterface();
      XBoardInterface(std::istream& in, std::ostream& out);
      virtual ~XBoardInterface();
      
      void processCommand( );
      Game* getGame();
      SmartPointer<Move> readMove(const std::string&);
      std::string moveToString( SmartPointer<Move> move );
    protected:
      void search();
      // specific commands:
      void noOperation();
      void go();
      void newGame();
      void usermove();
      void result();
      void setboard();
      void undo();
      void remove();
      void board();
    private:
      void initialize();
      double timeToSearch() const;
      void saveRecord();
      void learn();
      void makeMove(SmartPointer<Move> move);
      void reportResult();
      void checkTactics();
      void writeLeafPosition(std::vector<SmartPointer<Move> >& pv);
      void sendMove();
      Game* game;
      HashedAlphaBeta* algorithm;
      Evaluation* evaluation;
      //GameRecord* record;
      std::ofstream logFile;
      std::ofstream learningFile;
      Color* myColor;
      std::stack<SmartPointer<Move> > moves;
      static bool idle;
      static void signalHandler(int);
      int lastDepth;
      Evaluation::Score lastScore;
      std::vector<std::string> epdStrings;
    };
  }; // namespace XBoard
}; // namespace Alice
# endif // XBoardInterface_h
