// -*- c++ -*-

# ifndef XBoardBase_h
# define XBoardBase_h
# include <map>
# include <string>
# include <XBoard/XBoardFeature.h>
# include <fstream>
# include <XBoard/TimeControl.h>
namespace Alice
{
  namespace XBoard
  {
    class XBoardBase
    {
    public:
      enum Mode
	{
	  FORCE,
	  GO
	};
      typedef TimeControl::LimitType LimitType;
      XBoardBase(std::istream& in, std::ostream& out);
      virtual ~XBoardBase();
      int getProtocolVersion() const;
      XBoardFeature* getFeature(const std::string& name);
      void acceptFeature( const std::string& name );
      void sendFeatureRequest( );
      int getOwnTime() const;
      int getOtherTime() const;
      bool shouldPonder() const;
      bool shouldQuit() const;
      int getMovesPerSession() const;
      int getTimePerSession() const;
      int getTimeIncrement() const;
      std::string getOpponentName() const;
      std::string getResult() const;
      std::string getResultComment() const;
      Mode getMode() const;
      bool opponentIsComputer() const;
      virtual void search() = 0;
      virtual void processCommand();
      LimitType getLimitType() const;
      int getMaxDepth() const;
      int getMyRating() const;
      int getOpponentRating() const;
      const std::string& getIcsHostName() const;
    protected:
      void setUpFeatures();
      void initialize();
      typedef void (XBoardBase::*Command)();
      virtual void accepted();
      virtual void black();
      virtual void computer();
      virtual void easy();
      virtual void force();
      virtual void go();
      virtual void hard();
      virtual void level();
      virtual void name();
      virtual void newGame();
      virtual void otim();
      virtual void ping();
      virtual void protover();
      virtual void quit();
      virtual void random();
      virtual void rejected();
      virtual void result();
      virtual void time();
      virtual void usermove();
      virtual void white();
      virtual void xboard();

      virtual void draw();
      virtual void setboard();
      virtual void edit();
      virtual void hint();
      virtual void bk();
      virtual void undo();
      virtual void remove();
      virtual void post();
      virtual void nopost();
      virtual void analyze();
      virtual void rating();
      virtual void ics();
      virtual void pause();
      virtual void resume();
      virtual void sd();
      virtual void st();

      virtual void board();
      std::map<std::string, Command> commands;
      std::map<std::string, XBoardFeature*> features;
      int protocolVersion;
      bool pondering;
      Mode mode;
      bool oppComputer;
      std::istream& input;
      std::ostream& output;
      void setOwnTime( int t );
      void setOtherTime( int t );
      bool shouldQuit_;
      int maxDepth;
      std::string resultString;
      std::string resultComment;
      int movesSoFar;
      TimeControl timeControl;
    private:
      int myRating;
      int opponentRating;
      std::string icsHostName;
      std::string opponentName;
    }; // class XBoardBase

  }; // namespace XBoard
  
}; // namespace Alice

# endif // XBoardBase_h
