# ifndef TimeControl_h
# define TimeControl_h

namespace Alice
{
  namespace XBoard 
  {
    class TimeControl
    {
    public:
      enum LimitType{ NORMAL, FIXED_DEPTH, FIXED_TIME };
      int ownTime;
      int otherTime;
      LimitType limitType;
      int movesPerSession;
      int getSecondsPerSession() const;
      void setSecondsPerSession(int x);
      int getTimeIncrement() const;
      void setTimeIncrement( int x );
      void setTimeControl( int minutes, int increment);
      double timeToSearch( int movesSoFar ) const;
    private:
      int getOwnTime() const
      {
	return ownTime;
      };
      int getMovesPerSession() const
      {
	return movesPerSession;
      };
      int timeIncrement;
      int secondsPerSession;
    };
  }; // namespace XBoard
};// namespace Alice
# endif
