/***************************************************************************
                          TableEntry.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef TableEntry_h
# define TableEntry_h
# include "Moves/Move.h"
# include "Game/Evaluation.h"
# include <SmartPointer.h>
# include "TranspositionTable/HashCode.h"
# include <iostream>
namespace Alice
{
class TableEntry
{
public:
  enum BoundType{EXACT, LOWER, UPPER};
  TableEntry();
  void clear();
  uint64  identifier() const;
  int cost() const;
  int depth() const;
  Evaluation::Score score() const;
  SmartPointer<Move> bestMove() const;
  bool cutsOff(int depth, 
	       Evaluation::Score alpha, 
	       Evaluation::Score beta,
	       Evaluation::Score& result) const;
  bool cutsOff(int depth, Evaluation::Score alpha,
	       Evaluation::Score beta) const
  {
    Evaluation::Score dummy(0);
    return cutsOff(depth, alpha, beta, dummy);
  };
  bool store(BoundType type, int cost, int depth, 
	     Evaluation::Score score,
	     SmartPointer<Move> move,
	     uint64 identifier);
  void printScore(std::ostream& out)const;
 private:
  void storeExact(int cost, int depth, Evaluation::Score score,
		  SmartPointer<Move> move, uint64 identifier);
  
  void storeLower(int cost, int depth, Evaluation::Score score,
		  SmartPointer<Move> move, uint64 identifier);
  
  void storeUpper(int cost, int depth, Evaluation::Score score,
		  SmartPointer<Move> move, uint64 identifier);
			
  uint64  mIdentifier;  // 8
  BoundType mType;	      //4
  int mCost;		      // 4
  int mDepth;		      // 4
  Evaluation::Score lowerScore;	 // 4
  Evaluation::Score upperScore;	 // 4
  SmartPointer<Move> mBestMove;  // 4
};

}; // namespace Alice
# endif // TableEntry_h
