/// -*-c++-*-

# ifndef HashTable_h
# define HashTable_h

# include <Game/GameObserver.h>

# include <TranspositionTable/HashCode.h>
# include <TranspositionTable/HashCodeTable.h>
# include <stack>
namespace Alice
{
class Piece;
class HashTable
  : public GameObserver
{
public:
  HashTable(int bits);
  virtual ~HashTable();
  void setEnPassantSquare(Square ep);
  void clearEnPassantSquare(Square ep);
  const HashCode& hashCode(const Piece* piece, 
			   const Square& square) const;
  virtual void basicDoMove(Move& move);
  virtual void basicTakeBack(Move& move);
  void doNullMove();
  void takeBackNullMove();
  virtual void doSimpleMove(SimpleMove& move);
  virtual void doCapturingMove(CapturingMove& move);
  virtual void doPromotingMove(PromotingMove& move);
  void doPromotingCapture(PromotingCapture& move);
  virtual void doEnPassantMove(EnPassantMove& move);
  virtual void doDoubleStep(DoubleStep& move);
  virtual void update();
  virtual void downdate();
  const HashCode& getCurrentCode() const
    {
      //return mCurrentCode;
      return codeStack.top();
    };
protected:
  
  HashCode mCurrentCode;
  HashCode colorCode;
  HashCodeTable whiteKingCode;
  HashCodeTable blackKingCode;
  HashCodeTable whiteQueenCode;
  HashCodeTable blackQueenCode;
  HashCodeTable whiteRookCode;
  HashCodeTable blackRookCode;
  HashCodeTable whiteBishopCode;
  HashCodeTable blackBishopCode;
  HashCodeTable whiteKnightCode;
  HashCodeTable blackKnightCode;
  HashCodeTable whitePawnCode;
  HashCodeTable blackPawnCode;
  HashCodeTable enPassantCode;

  std::stack<HashCode> codeStack;
protected:
  HashCode& currentCode()
    {
      //return mCurrentCode;
      return codeStack.top();
    };
  
};
}; // namespace Alice
# endif
