/***************************************************************************
                          HashCode.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// -*-c++-*-
# ifndef HashCode_h
# define HashCode_h

# ifdef __GNUC__
typedef unsigned long long uint64;
# else
# include <algorithm>
# include <bitset>
typedef std::bitset<64> uint64;
# endif

namespace Alice
{
class HashCode
{
public:
  HashCode(short primaryBits = 10);
  unsigned long primary() const;
  const uint64& secondary() const;
  HashCode& operator ^= (const HashCode& otherCode);
  bool operator == (const HashCode& otherCode) const
  { return primary() == otherCode.primary() &&
      secondary() == otherCode.secondary();
  };
  bool operator != (const HashCode& otherCode) const
  {
  	return ! ((*this) == otherCode);
  };
private:
  unsigned long mPrimary;
  uint64  mSecondary;
};
// inline functions
inline
HashCode&
HashCode::operator ^= (const HashCode& otherCode)
{
  mPrimary ^= otherCode.primary();
  mSecondary ^= otherCode.secondary();
  return *this;
};

}; // namespace Alice
# endif // HashCode_h
