/***************************************************************************
                          TestPositionSuite.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef TestPositionSuite_h
# define TestPositionSuite_h

# include "TestData/TestPosition.h"
# include <list>

namespace Alice
{
class TestPositionSuite
{
public:
  TestPositionSuite(const char* filename);
  int numberOfPositions() const;
  void run(int depth);
  void runTime(int seconds);
  void writeIndexPage(int number, int nodes,
		      double odd, double even, int correct, double time) const;
  const TestPosition& getPosition(int i)
  {
    return positions.at(i); 
  };
private:
  std::vector<TestPosition> positions;
};
}; // namespace Alice
# endif // TestPositionSuite_h
