// -*-c++-*-
/***************************************************************************
                          TestPosition.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# ifndef TestPosition_h
# define TestPosition_h
# include <string>
# include <iostream>
# include <SmartPointer.h>
# include <Moves/Move.h>
# include <map>
# include <utility/Serializable>
namespace Alice
{
class HashedAlphaBeta;
class TestPosition
  : public utility::Serializable
{
public:
  TestPosition(std::string pForsythe="",
	       std::string pMove="",
	       std::string pTitle="");
  TestPosition( const Game& g );
  std::string forsythe() const;
  std::string bestMove() const;
  std::string title() const;
  std::string principalVariation() const;
  std::string getColorToMove() const;
  std::string getCastlingRights() const;
  std::string getEnPassantSquare() const;
  std::string getOperand(const std::string& op) const;
  void setOperand( const std::string& preimage,
		   const std::string& image );
  void read(std::istream& in);
  void readEPD( std::istream& in );
  void write(std::ostream& out) const;
  void writeEPD( std::ostream& out ) const;
  bool search(int depth, HashedAlphaBeta& algo);
  const Move& solution() const;
  void printHeader() const;
private:
  SmartPointer<Move> _bestMove;
  std::string mTitle;
  std::string mForsythe;
  std::string mBestMove;
  std::string mPrincipalVariation;
  std::string colorToMove;
  std::string castlingRights;
  std::string enPassantSquare;
  std::map<std::string, std::string> operations;
  void readEPDOperation( std::istream& in );
};
}; // namespace Alice
# endif // TestPosition_h

