// -*- c++ -*-

//////////////////////////////////////////////////
// (c) MMIII Sven Reichard
// 


# ifndef ProofNumberNode_h
#  define ProofNumberNode_h
# include <vector>
# include <Moves/Move.h>
# include <SmartPointer.h>
using namespace Alice;
class ProofNumberNode
{
public:
  static const int _INFINITY;
  ProofNumberNode();
  virtual ~ProofNumberNode();
  int getProofNumber() const;
  int getDisproofNumber() const;
  bool isExpanded() const;
  bool needsExpansion() const;
  bool isLegal() const;
  int getNumberOfChildren() const;
  int getChildToExpand() const;
  ProofNumberNode* getChild(int i);
  short getDepth() const
  {
    return depth;
  };
  short getHeight() const;
  void expand( int nChildren );
  bool adjustNumbers();
  void setProven();
  void setDisproven();
  void setIllegal(){legal = false;}
  void setDisproofNumber(int i)
  {
    disproofNumber = i;
  };
  SmartPointer<Move>& getIncomingMove();
  void setIncomingMove(SmartPointer<Move>&);
  int lengthToMate() const;
  bool operator<(const ProofNumberNode& node) const
  {
    return lengthToMate() > node.lengthToMate();
  };
  static bool compare(const ProofNumberNode* node1, const ProofNumberNode* node2)
  {
    return *node1 < *node2;
  };
  void sort()
  {
    std::sort(children.begin(), children.end(), compare);
  };
  static int getNumberOfInstances();
  void setProofNumber( int n )
  {
    proofNumber = n;
  };
  void swap(ProofNumberNode& node)
  {
    std::swap(proofNumber, node.proofNumber);
    std::swap(disproofNumber, node.disproofNumber);
    std::swap(children, node.children);
    std::swap(depth, node.depth);
    std::swap(expanded, node.expanded);
    std::swap(terminal, node.terminal);
    std::swap(legal, node.legal);
  }
private:
  static int instances;
  int proofNumber;
  int disproofNumber;
  std::vector<ProofNumberNode*> children;
  SmartPointer<Move> incomingMove;
  short depth;
  short height;
  bool expanded;
  bool terminal;
  bool legal;
} ;

# endif // ProofNumberNode_h
