// -*- c++ -*-

//////////////////////////////////////////////////
// (c) MMIV Sven Reichard
// 


# ifndef PrincipalVariation_h
#  define PrincipalVariation_h
# include <Moves/Move.h>
# include <SmartPointer.h>
# include <vector>
# include <iostream>
namespace Alice
{
  class PrincipalVariation
  {
  public:
    PrincipalVariation();
    virtual ~PrincipalVariation();
    int length() const;
    PrincipalVariation* next();
    void insert( const SmartPointer<Move>& move );
    void clear();
    SmartPointer<Move> getMove( int which ) const;
    void printTo( std::ostream& out ) const;
  private:
    PrincipalVariation* mNext;
    std::vector<SmartPointer<Move> > moves;
  };
}; // namespace Alice

# endif // PrincipalVariation_h
