/***************************************************************************
                          ShortMovingPiece.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef ShortMovingPiece_h
# define ShortMovingPiece_h

# include "Pieces/Piece.h"
# include <list>
# include <Bitboard.h>
namespace Alice
{
class Move;
class Direction;
class Square;
class Board;
class ShortMovingPiece:
  public Piece
{
public:
  virtual ~ShortMovingPiece();
  void pseudolegalMoves ( MoveList &, 
			  const Square &, 
			  const Board &, 
			  bool capturesOnly) const;
  virtual Bitboard getAttacks( const Square& sq ) const = 0;
protected:
  ShortMovingPiece(Color* color, char dLetter);
  virtual const std::list<const Direction*>& directions() const=0;
  typedef std::list<const Direction*>::const_iterator DirectionIterator;
  void pseudoLegalMovesInDirection(MoveList&, const Square&, const Board&, 
				   bool capturesOnly, 
				   const Direction* dir) const;
};
}; // namespace Alice
# endif // ShortMovingPiece_h
