/***************************************************************************
                          Piece.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-
# ifndef Piece_h
# define Piece_h
# include <list>
# include <vector>
# include <assert.h>
# include <SmartPointer.h>
# include <Game/Evaluation.h>
# include <Color.h>
# include <Moves/MoveList.h>
namespace Alice
{
class Move;
class Direction;
class Square;
class Board;

/** I represent the pieces on the chess board.
    My instances know how to move and how to display themselves.
 */
class Piece
{
public:
  virtual ~Piece();
  /** A letter representing the piece.
      For displaying an Ascii reprsentation of the position. Currently,
      the standard English abbreviations are used (K, Q, R, B, N, P).
  */
  char displayLetter() const {return mDisplayLetter;};
  /** A letter representing piece and color.
      This is used for the Forsythe notation of positions. Capital
      letters represent white pieces, small letters, black pieces.
  */
  char forsytheLetter() const ;
  /**@name  Piece recognition*/
  //@{
  bool isNull() const;
  virtual bool isKing() const;
  virtual bool isQueen() const;
  virtual bool isRook() const;
  virtual bool isBishop() const;
  virtual bool isKnight() const;
  bool isPawn() const { return displayLetter() == 'P';};
  //@}
  /** Returns the Color of the receiver.
   */
  Color* color() const {return mColor;};
  /**@name Instance creation*/
  //@{
  static Piece* newKing(Color* aColor);
  static Piece* newQueen(Color* aColor);
  static Piece* newRook(Color* aColor);
  static Piece* newBishop(Color* aColor);
  static Piece* newKnight(Color* aColor);
  static Piece* newPawn(Color* aColor);
  static Piece* newNullPiece();
  static Piece* fromForsytheLetter(char c);
  //@}
  /** Move generator.
   * Adds all possible moves of the receiver to \c moves, 
   * if it stands on the given square of the given board.
   * @param moves  list of moves to be added to
   * @param square where the piece is
   * @param board  the whole position, to detect captures
   */
  virtual void pseudolegalMoves (MoveList& moves, 
				 const Square& square, 
				 const Board& board,
				 bool capturesOnly) const;
  virtual bool movesInDirection(const Direction* dir) const;
  virtual bool attacks(const Direction* dir, const Square& location,
		       const Square& target) const  = 0;
  virtual Evaluation::Score basicValue() const;
  virtual int centralizationFactor() const;
  virtual Piece* clone() const = 0;
protected:
  Piece(Color* aColor, char dLetter);
  bool mIsNull;
private:
  Color* mColor;
  const char mDisplayLetter;
};

inline bool
Piece::isNull() const
{
  return mIsNull;
};
}; // namespace Alice
# endif // Piece_h
