/***************************************************************************
                          Pawn.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-
# ifndef Pawn_h
# define Pawn_h

# include "Pieces/Piece.h"

namespace Alice
{

class Pawn:
  public Piece
{
public:
  Pawn(Color* aColor);
  virtual ~Pawn();
  virtual char displayLetter() const;
  virtual void pseudolegalMoves (MoveList &, 
				 const Square &, const Board &, bool capturesOnly) const;
  bool isPawn() const;
  virtual Evaluation::Score basicValue() const;
  virtual bool attacks(const Direction* dir, const Square& location,
		       const Square& target)const;
  virtual int centralizationFactor() const;
  Piece* clone() const;
protected:
private:
  void allMoves(MoveList& moves, const Square& source,
		const Square& destination) const;
  void allCaptures(MoveList& moves, const Square& source,
		const Square& destination) const;
};
}; // namespace Alice
# endif // Pawn_h
