/***************************************************************************
                          LongMovingPiece.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef LongMovingPiece_h
# define LongMovingPiece_h

# include "Pieces/Piece.h"
# include <list>
# include <Bitboard.h>
namespace Alice
{
class Move;
class Direction;
class Square;
class Board;
class LongMovingPiece:
  public Piece
{
public:
  virtual ~LongMovingPiece();
  void pseudolegalMoves 
  (MoveList&, const Square &, const Board &, bool capturesOnly)const ;
  virtual bool attacks(const Direction* dir, const Square& location,
		       const Square& target) const;
protected:
  virtual Bitboard getAttacks( const Board& b, const Square& sq ) const = 0;
  LongMovingPiece(Color* color, char dLetter);
  virtual const std::list<const Direction*>& directions() const =0;
};
}; // namespace Alice
# endif // LongMovingPiece_h
