//-*-c++-*-
/***************************************************************************
                          Knight.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# ifndef Knight_h
# define Knight_h

# include "Pieces/ShortMovingPiece.h"
# include <list>
# include <Bitboard.h>
namespace Alice
{

class Direction;

class Knight:
  public ShortMovingPiece
{
public:
  Knight(Color* aColor);
  virtual ~Knight();
  virtual char displayLetter() const;
  virtual bool movesInDirection(const Direction* dir) const;
  virtual bool isKnight() const;
  virtual Evaluation::Score basicValue() const;
  virtual bool attacks(const Direction* dir, const Square& location,
		       const Square& target) const;
  virtual int centralizationFactor() const;
  Bitboard getAttacks( const Square& sq ) const;
  Piece* clone() const;
protected:
	const std::list<const Direction*>& directions() const;
private:
	static std::list<const Direction*> mDirections;
};
}; // namespace Alice
# endif // Knight_h
