/***************************************************************************
                          King.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-
# ifndef King_h
# define King_h

# include "Pieces/ShortMovingPiece.h"
# include <list>
# include <Bitboard.h>
namespace Alice
{
class Direction;
class King:
  public ShortMovingPiece
{
public:
  King(Color* aColor);
  virtual ~King();
  virtual char displayLetter() const;
  virtual bool isKing() const;
  virtual bool attacks(const Direction* dir, const Square& location,
		       const Square& target) const;
  virtual int centralizationFactor() const;
  Bitboard getAttacks( const Square& sq ) const;
  Piece* clone() const;
protected:
  const std::list<const Direction*>& directions() const;
private:
  static std::list<const Direction*> mDirections;
};
}; // namespace Alice
# endif // King_h
