//-*-c++-*-
/***************************************************************************
                          Bishop.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# ifndef Bishop_h
# define Bishop_h

# include <Pieces/LongMovingPiece.h>
# include <Bitboard.h>
namespace Alice
{
class Bishop:
  public LongMovingPiece
{
public:
  Bishop(Color* aColor);
  virtual ~Bishop();
  virtual char displayLetter() const;
  virtual bool movesInDirection(const Direction* dir) const;
  virtual Evaluation::Score basicValue() const;
  virtual bool isBishop() const;
  virtual int centralizationFactor() const;
  Bitboard getAttacks( const Board& b, const Square& sq ) const;
  Piece* clone() const;
protected:
	const std::list<const Direction*>&directions() const;
private:
	static std::list<const Direction*> mDirections;
private:
};
}; // namespace Alice
# endif // Bishop_h
