// -*-c++-*-
/***************************************************************************
                          SimpleMove.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

# ifndef SimpleMove_h
# define SimpleMove_h

# include "Moves/Move.h"
# include <SmartPointer.h>
namespace Alice
{
  class Board;
  class SimpleMove:
    public Move
  {
  public:
  protected:
    struct Link{Link* next;};
    SimpleMove(const Square& from, const Square& to);
  public:
    virtual ~SimpleMove();
    virtual void makeOn(Board& b) ;
    virtual void takeBackOn(Board& b);
    virtual void makeOn(GameObserver& b);
    virtual void takeBackOn(GameObserver& b);
    virtual bool isLegal(const Game& game) const;
    static SmartPointer<Move> createInstance(const Square& from, const Square& to) ;
    void operator delete(void* p, size_t s);
    static void printInfo();
    static void initializeClass();
    static void cleanUpClass();
  protected:
    static Link* simplePool;
    static Link* doublePool;
  private:
    static int createdNew;
    static int reuse;
    static SmartPointer<Move> instances[64][64];
    class Initializer
    {
    public:
      Initializer()
      {
	SimpleMove::initializeClass();
      };
      ~Initializer()
      {
	SimpleMove::cleanUpClass();
      };
    };
    static Initializer initializer;
    
  };
}; // namespace Alice
# endif
