/***************************************************************************
                          PromotingCapture.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// -*-c++-*-

# ifndef PromotingCapture_h
# define PromotingCapture_h

# include "Moves/Move.h"
namespace Alice
{
class Piece;
class Board;
class PromotingCapture:
  public Move
{
public:
  PromotingCapture(const Square& from, const Square& to, 
		   const Piece* promoted);
  virtual ~PromotingCapture();
  virtual void makeOn(Board& b) ;
  virtual void takeBackOn(Board& b);
  virtual void makeOn(GameObserver& b);
  virtual void takeBackOn(GameObserver& b);
  virtual void printOn(std::ostream& out) const;
  const Piece* promotedPiece() const{return mPromoted;}
  const Piece* capturedPiece() const{return mCapture;}
  void modifySan(SanNotation& san) const;
  virtual bool isCapture() const
  { return true;}
  bool isLegal(const Game&) const;
private:
  const Piece* mPromoted;
  const Piece* mPawn;
  const Piece* mCapture;
};
}; // namespace Alice

# endif
