/***************************************************************************
                          Move.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// -*-c++-*-

# ifndef Move_h
# define Move_h

# include "Square.h"
# include <iostream>
# include <string>

namespace Alice
{
class Board;
class GameObserver;
class Game;
class SanNotation;
class PromotingMove;
class Move
{
public:
  virtual ~Move();
  const Square& source() const{return mSource;};
  const Square& destination() const{return mDestination;};
  virtual void makeOn(Board& b) = 0;
  virtual void takeBackOn(Board& b) = 0;
  virtual void makeOn(GameObserver& b);
  virtual void takeBackOn(GameObserver& b);
  virtual void printOn(std::ostream& out) const;
  virtual bool isCapture() const
  { return false;}
  bool fitsDescription(const std::string description) const;
  virtual bool fitsDescription(const SanNotation& san) const;
  /** simple sanity check */
  virtual bool isLegal(const Game& game) const;
  virtual void modifySan(SanNotation& san) const;
  static int getInstances() {return 0;}
  static void printStatistics();
  virtual void destroy();
  virtual bool operator==(const Move& move) const;
  bool operator!=(const Move& move) const;
  virtual bool equalsPromotingMove(const PromotingMove& move) const;
protected:
  Move(const Square& from, const Square& to);
private:
  Square mSource;
  Square mDestination;
};

inline
bool
Move::operator!=(const Move& move) const
{
  return !(*this == move);
};
}; // namespace Alice

# endif
