/***************************************************************************
                          EnPassantMove.h  -  description
                             -------------------
    begin                : Sat Aug 25 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENPASSANTMOVE_H
#define ENPASSANTMOVE_H

#include "Moves/CapturingMove.h"
# include "Square.h"
namespace Alice
{
/**I represent an en-passant move, i.e., a move capturing a pawn 
while it makes a double step.
  *@author Sven Reichard
  */

class EnPassantMove : public CapturingMove  {
public: 
	EnPassantMove(const Square& from, const Square& to,
								const Square& capturing);
	virtual ~EnPassantMove();
	void makeOn(Board& b);
	void takeBackOn(Board& b);
	virtual void makeOn(GameObserver& b);
  virtual void takeBackOn(GameObserver& b);
	const Square& capturedSquare() const
		{return mCapturedSquare;}
  /** adds suffix "e.p." */
  void printOn(std::ostream& out) const;
  /** check if there is an e.p. square */
  bool isLegal(const Game& game) const;
  void* operator new(size_t s);
  void operator delete(void* p, size_t s);
private:
	Square mCapturedSquare;
	static Link* enPassantPool;
};
}; // namespace Alice

#endif
