/***************************************************************************
                          DoubleStep.h  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOUBLESTEP_H
#define DOUBLESTEP_H

#include "Moves/SimpleMove.h"
# include <Square.h>
namespace Alice
{
/**represents a pawns double step
  *@author Sven Reichard
  */

class DoubleStep : public SimpleMove  {
protected:
	DoubleStep(const Square& from, const Square& to, const Square& via);
public:
	virtual ~DoubleStep();
	const Square& passedSquare() const {return mVia;}
	void makeOn(GameObserver& b);
	static DoubleStep* createInstance(const Square& from, const Square& to, const Square& via);
	void* operator new(size_t s);
	void operator delete(void* p, size_t s);
	static void printInfo();
private:
//	DoubleStep(const Square& from,const Square& to);
	Square mVia;
	static int createdNew;
	static int reuse;
};
}; // namespace Alice

#endif
