/***************************************************************************
                          CastlingMove.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// -*-c++-*-

# ifndef CastlingMove_h
# define CastlingMove_h

# include "Moves/Move.h"
namespace Alice
{

class Board;
class CastlingMove:
  public Move
{
public:
  CastlingMove(const Square& from, const Square& to,
	       const Square& rookFrom, const Square& rookTo);
  virtual ~CastlingMove();
  virtual void makeOn(Board& b) ;
  virtual void takeBackOn(Board& b);
  virtual void makeOn(GameObserver& b);
  virtual void takeBackOn(GameObserver& b);
  virtual void printOn(std::ostream& out) const;
  virtual bool isLegal(const Game& game) const;
  void modifySan(SanNotation& san) const;
  const Square& getRookSource() const {return rookSource;};
  const Square& getRookDestination() const{return rookDestination;};
private:
  Square rookSource;
  Square rookDestination;

};
}; // namespace Alice

# endif
