/***************************************************************************
                          CapturingMove.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// -*-c++-*-

# ifndef CapturingMove_h
# define CapturingMove_h

# include "Moves/Move.h"
namespace Alice
{

class Board;
class Piece;
class CapturingMove:
  public Move
{
public:
  CapturingMove(const Square& from, const Square& to);
  virtual ~CapturingMove();
  virtual void makeOn(Board& b) ;
  virtual void takeBackOn(Board& b);
  virtual void makeOn(GameObserver& b);
  virtual void takeBackOn(GameObserver& b);
  const Piece* capture() const;
  virtual void printOn(std::ostream& out) const;
  bool isCapture() const
  { return true;}
  /** make sure there is something to capture */
  bool isLegal(const Game& game)  const;
  static void printInfo();	
  void* operator new(size_t s);
	void operator delete(void* p, size_t s);

protected:
	struct Link{Link* next;};
  const Piece* mCapture;
	static int created;
	static int deleted;
	static int reuse;
	static Link* capturePool;
};
}; // namespace Alice

# endif
