// -*- c++ -*-

# ifndef TagSet_h
# define TagSet_h
# include <string>
# include <map>
# include <iosfwd>
# include <utility/Serializable>
# include <vector>
namespace Alice
{
  class TagSet
    : public virtual utility::Serializable
  {
  public:
    TagSet();
    const std::map<std::string, std::string>& getTags() const;
    std::map<std::string, std::string>& getTags();
    void setTag(const std::string& name, const std::string& value);
    std::string getTag( const std::string& name );
    void readTag(std::istream& in);
    void write( std::ostream& out ) const;
    void read( std::istream& in );
  private:
    std::map<std::string, std::string> _tags;
    void writeTag( std::ostream& out, const std::string& tag ) const;
    std::vector<std::string> standardTags;
  };
};
# endif // TagSet_h
