// -*-c++-*-

# ifndef PositionalEvaluation_h
# define PositionalEvaluation_h

# include "Game/Evaluation.h"
# include <Color.h>
# include <Game/EvaluationFeature.h>
# include <vector>
namespace Alice
{
  class TestPositionSuite;

class PositionalEvaluation
  : public Evaluation
{
public:
  enum
  {
    KNIGHT_CENTRALIZATION =   6,
    BISHOP_CENTRALIZATION =   6,
    ROOK_CENTRALIZATION   =   2,
    QUEEN_CENTRALIZATION  =   2,
    PAWN_CENTRALIZATION   =   7,
    KING_CENTRALIZATION   = -10,
    BLOCKED_ROOK_PENALTY  = 300
  };
public:
  PositionalEvaluation();
  virtual ~PositionalEvaluation();
  void setBasicValue(short int);
  short int getBasicValue() const;
  static int centralization(const Square& sq);
  virtual Score boundedScore( Score alpha, Score beta ) const;
  int kingSafetyDeficiencies( const Color* ) const;
  void addDifference( float factor );
  void adjustWeights();
  void print();
  Score totalError( const std::vector<Evaluation::Score>& scores );
  void
  computeScores(TestPositionSuite& suite,
		std::vector<Evaluation::Score>& scores);
  void
  adjustWeights(TestPositionSuite& suite,
		const std::vector<Evaluation::Score>& scores);
protected:
  Score pieceValue(const Piece* p) const;
  Score evaluateCentralization(const Color* myColor) const;
private:
  short int _basicValue;
  mutable EvaluationFeature* pawnStructure;
  mutable EvaluationFeature* developmentFeature;
  mutable EvaluationFeature* castlingFeature;
  mutable EvaluationFeature* piecePlacementFeature;
  double sigmoid( double x ) const;
  double sigmoidDerivative( double x ) const;
};
}; // namespace Alice

# endif // PositionalEvaluation_h
