// -*- c++ -*-

//////////////////////////////////////////////////
// (c) MMIV Sven Reichard
// 


# ifndef PawnStructureFeature_h
#  define PawnStructureFeature_h
# include <vector>
# include <Color.h>
# include <Game/EvaluationFeature.h>
namespace Alice
{
  class Game;
  class PawnStructureFeature
    : public EvaluationFeature
  {
    enum{
      DOUBLE_PAWN_PENALTY   = 100,
	ISOLATED_PAWN_PENALTY = 250,
	PASSED_PAWN_BONUS = 500,
	KING_SAFETY_PENALTY = 300
	};
    enum
      {
	DOUBLE_PAWN,
	ISOLATED_PAWN,
	PASSED_PAWN,
	KING_SAFETY,
	MAX_WEIGHT
      };
  public:
    PawnStructureFeature();
    virtual ~PawnStructureFeature();
    void countPawns( const Game* );


    int numberOfPawnsOnFile(int file, const Color* color) const;
    int topPawn(int file, const Color* color) const;
    int bottomPawn(int file, const Color* color) const;
    int kingSafetyDeficiencies( const Color* ) const;
    void evaluateIsolatedPawns( const Color* );
    void evaluateDoubledPawns(  );
    bool isPassedPawn(Game* g, const Square& sq);
    void computeGradient( Game* g );
  private:
    const Game* game;
    std::vector<short int> _whitePawnsOnFile;
    std::vector<short int> _blackPawnsOnFile;
    std::vector<short int> _whiteTopPawnOnFile;
    std::vector<short int> _blackTopPawnOnFile;
    std::vector<short int> _whiteBottomPawnOnFile;
    std::vector<short int> _blackBottomPawnOnFile;
    int countPassedPawns( Game* g );
  }; // class PawnStructureFeature

}; // namespace Alice

# endif // PawnStructureFeature_h
