// -*-c++-*-

# ifndef GameRecord_h
# define GameRecord_h
# include <list>
# include <Game/Game.h>
# include <Moves/Move.h>
# include <SmartPointer.h>
# include <iosfwd>
# include <Game/TagSet.h>
# include <Game/MoveText.h>
namespace Alice
{

  class GameRecord
  {
  public:
    GameRecord();
    std::string getTag(const std::string& name);
    void setTag(const std::string& name, const std::string& value);
    int plyCount() const;
    void addMove(const std::string& move);
    void addMove(SmartPointer<Move> move);
    void read(std::istream& in);
    void printTags() const;
    std::string getForsytheString(int ply);
    SmartPointer<Move> getMove(int which);
    void write( std::ostream& out );
    void insertVariation( std::vector<SmartPointer<Move> >& pv);
  private:
    TagSet tagSet;
    MoveText moveText;
  };
};// namespace Alice

# endif // GameRecord_h
