/***************************************************************************
                          GameObserver.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef GameObserver_h
# define GameObserver_h
namespace Alice
{

class Move;
class SimpleMove;
class CapturingMove;
class PromotingMove;
class PromotingCapture;
class CastlingMove;
class DoubleStep;
class EnPassantMove;
class GameBroadcaster;
class Game;
class GameObserver
{
public:
  virtual ~GameObserver();
  virtual void startObserving(Game*);
  virtual void stopObserving();
  virtual void basicDoMove(Move& move);
  virtual void doSimpleMove(SimpleMove& move);
  virtual void doCapturingMove(CapturingMove& move);
  virtual void doPromotingMove(PromotingMove& move);
  virtual void doPromotingCapture(PromotingCapture& move);
  virtual void doCastlingMove(CastlingMove& move);
  virtual void doDoubleStep(DoubleStep& move);
  virtual void doEnPassantMove(EnPassantMove& move);
  virtual void doNullMove() = 0;
  virtual void basicTakeBack(Move& move);
  virtual void takeBackSimpleMove(SimpleMove& move);
  virtual void takeBackCapturingMove(CapturingMove& move);
  virtual void takeBackPromotingMove(PromotingMove& move);
  virtual void takeBackPromotingCapture(PromotingCapture& move);
  virtual void takeBackCastlingMove(CastlingMove& move);
  virtual void takeBackDoubleStep(DoubleStep& move);
  virtual void takeBackEnPassantMove(EnPassantMove& move);
  virtual void takeBackNullMove() = 0;
  virtual bool isLateObserver() const;
protected:
  GameObserver();
  Game* observedGame;
};
}; // namespace Alice

# endif // GameObserver_h
