// -*-c++-*-
/***************************************************************************
                          GameBroadcaster.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef GameBroadcaster_h
# define GameBroadcaster_h
# include "Game/GameObserver.h"
# include <list>
namespace Alice
{

class GameBroadcaster:
  public GameObserver
{
public:
  virtual ~GameBroadcaster();
  virtual void basicDoMove(Move& move);
  virtual void basicTakeBack(Move& move);
  void doNullMove();
  void takeBackNullMove();
  virtual void addObserver(GameObserver& observer);
  virtual void removeObserver(GameObserver& observer);
  const std::list<GameObserver*> observers() const;
protected:
  GameBroadcaster();
  std::list<GameObserver*> mObservers;
};
}; // namespace Alice

# endif // GameBroadcaster_h
