//-*-c++-*-
/***************************************************************************
                          Game.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

# ifndef Game_h
# define Game_h
# include "Game/GameBroadcaster.h"
# include "Board.h"
# include <list>
# include <string>
# include "Pieces/Piece.h"
# include <Color.h>
namespace Alice
{

class Direction;
class CheckSentry;
class EnPassantSentry;
class CastlingSentry;
class RepetitionSentry;
class Game:
  public GameBroadcaster
{
public:
  Game();
  virtual ~Game();
  virtual void basicDoMove(Move& move);
  virtual void basicTakeBack(Move& move);
  void doNullMove();
  void takeBackNullMove();
  virtual void doCapturingMove(CapturingMove& move);
  //virtual void takeBackCapturingMove(CapturingMove& move);
  const Board& board() const { return mBoard;};
  std::string forsytheString() const;
  void forsytheString(const std::string& str) ;
  Color* colorToMove() const;
  void pseudoLegalMoves(MoveList& moves, bool capturesOnly = false);
  bool isAttacked(const Square& sq, Color* color);
  bool isInCheck(Color* color);
  bool isStalemate();
  bool isRepeated();
  bool isAttackedFromDirection(const Direction& dir, const Square& sq,
			       Color* color);
  Square epSquare() const;
  virtual void addObserver(GameObserver& observer);
  virtual void removeObserver(GameObserver& observer);
  bool isRecapture() const;
  bool hasCastled(const Color*) const;
  bool canCastle( const Color*) const;
  std::string getEPDString() const;
  Square findKing( const Color* color ) const;
protected:
  //std::list<GameObserver*> mObservers;
  Board mBoard;
  Color* mColorToMove;
  CheckSentry* checkSentry;
  EnPassantSentry* epSentry;
  CastlingSentry* castlingSentry;
  RepetitionSentry* repetitionSentry;
  std::list<GameObserver*> mLateObservers;
  std::stack<bool> _recapture;
  std::stack<Square> _capturingSquare;
};
}; // namespace Alice

# endif // Game_h
