# ifndef EvaluationFeature_h
# define EvaluationFeature_h
# include <Game/Evaluation.h>
namespace Alice
{
  class Game;
  class EvaluationFeature
  {
  public:
    typedef Evaluation::Score Score;
    EvaluationFeature( int numberOfWeights, const char* fileName );
    virtual Evaluation::Score score(Game* g);
    void addDifference(float factor);
    void adjustWeights();
    void print();
    Score squaredNorm() const;
    virtual void computeGradient( Game* g);
  protected:
    void clearGradient();
    void setGradient( int i, Evaluation::Score x )
    {
      gradient[i] = x;
    };
    void addGradient( int i, Evaluation::Score x )
    {
      gradient[i] += x;
    };
  private:
    std::vector<Evaluation::Score> gradient;
    std::vector<Evaluation::Score> weights;
    std::vector<Evaluation::Score> difference;
    const char* mFileName;
    bool couldRead;
  }; // class EvaluationFeature
}; // namespace Alice

# endif // EvaluationFeature_h
