//-*-c++-*-
/***************************************************************************
                          Evaluation.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


# ifndef Evaluation_h
# define Evaluation_h
# include "Game/GameObserver.h"
# include "Square.h"
# include <Color.h>
# include <list>
# include <stack>

namespace Alice
{
class Piece;
class Evaluation:
  public GameObserver
{
public:
  typedef float Score;
  virtual ~Evaluation();
  virtual void basicDoMove(Move& move);
  virtual void basicTakeBack(Move& move);
  void doNullMove();
  void takeBackNullMove();
  virtual void doCapturingMove(CapturingMove& move);
  virtual void doPromotingMove(PromotingMove& move);
  virtual void doPromotingCapture(PromotingCapture& move);
  virtual void doEnPassantMove(EnPassantMove& move);
  virtual void startObserving(Game*);
  Evaluation();
  Score score() const;
  virtual Score boundedScore( Score alpha, Score beta ) const;
  void setBasicValue(short int);
  virtual Score pieceValue(const Piece* p) const;
  static Score stalemate() {
    return Score(0);
  };
  static Score mate() {
    return Score(-31000);
  };
  void verify() const;
private:
  std::stack<Score> mScoreStack;
  short int _basicValue;
};

//std::ostream&
//operator << (std::ostream& out, const Evaluation::Score& score);

inline
Evaluation::Score propagate(Evaluation::Score value)
{
  if (value < -30000)
    return (1-value);
  if (value > 30000)
    return (-1-value);
  return (-value);
};
  
inline
Evaluation::Score backPropagate(Evaluation::Score value)
{
  if (value > 30000)
    return (1-value);
  if (value < -30000)
    return (-1-value);
  return (-value);
};
inline bool
isMate(const Evaluation::Score& value)
{
  return (value > 30000) || (value < -30000);
};
}; // namespace Alice

# endif // Evaluation_h
