// -*- c++ -*-
/***************************************************************************
                          EnPassantSentry.h  -  description
                             -------------------
    begin                : Thu Aug 23 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENPASSANTSENTRY_H
#define ENPASSANTSENTRY_H

#include <Game/GameObserver.h>
# include <Square.h>
# include <stack>
namespace Alice
{

class DoubleStep;
/**keeps track of en passant squares
  *@author Sven Reichard
  */
class EnPassantSentry : public GameObserver  {
public: 
  EnPassantSentry();
  ~EnPassantSentry();
  Square square() const;
  void doNullMove() {epSquares.push(Square::invalid());};
  void takeBackNullMove() {epSquares.pop();};
  void basicDoMove(Move& move);
  void basicTakeBack(Move& move);
  void doDoubleStep(DoubleStep& move);
  std::string getEPDString() const;
 private:
  std::stack<Square> epSquares;
};
}; // namespace Alice

#endif
