/***************************************************************************
                          CheckSentry.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-

# ifndef CheckSentry_h
# define CheckSentry_h
# include "Game/GameObserver.h"
# include "Square.h"
# include <stack>
# include <Color.h>
namespace Alice
{


class CheckSentry:
  public GameObserver
{
public:
  virtual ~CheckSentry();
  virtual void basicDoMove(Move& move);
  virtual void basicTakeBack(Move& move);
  void doCastlingMove(CastlingMove& m);
  void doEnPassantMove(EnPassantMove& m);
  void doNullMove();
  void takeBackNullMove();
  virtual void startObserving(Game*);
  virtual void stopObserving();
  Square findKing(const Color* color) const;
  bool isInCheck(Color* color) const;
  bool isConsistent() const;
  bool isLateObserver() const;
  CheckSentry();
protected:
private:
  Square whiteKing;
  Square blackKing;
  std::stack<bool> whiteInCheck;
  std::stack<bool> blackInCheck;
};
}; // namespace Alice

# endif // CheckSentry_h
