// -*- c++ -*-
/***************************************************************************
                          sastlingSentry.h  -  description
                             -------------------
    begin                : Sun Sep 2 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CASTLINGSENTRY_H
#define CASTLINGSENTRY_H

#include <Game/GameObserver.h>
# include <Pieces/Piece.h>
# include <stack>
namespace Alice
{
class Move;
/**I observe the game and keep track of castling rights.
  *@author Sven Reichard
  */

class CastlingSentry : public GameObserver  {
public: 
  CastlingSentry();
  virtual ~CastlingSentry();
  bool canCastleShort();
  bool canCastleLong();
  bool hasCastled(const Color*) const;
  bool canCastle( const Color* ) const;
  void basicDoMove(Move& move);
  void basicTakeBack(Move& move);
  void doNullMove(){};
  void takeBackNullMove(){};
  virtual void doCastlingMove(CastlingMove& move);
  virtual void takeBackCastlingMove(CastlingMove& move);
  void generateMoves(MoveList& moves);
  std::string getEPDString() const;
private:
  enum {
    WHITE_SHORT = 0X01,
    WHITE_LONG  = 0X02,
    BLACK_SHORT = 0X04,
    BLACK_LONG  = 0X08,
    ALL_RIGHTS  = 0X0F
  };
  std::stack<int> flagStack;
  bool whiteHasCastled;
  bool blackHasCastled;
};
}; // namespace Alice

#endif
