// -*- c++ -*-

# ifndef FullMoveComp_h
# define FullMoveComp_h

# include <Board.h>
# include <Moves/Move.h>
# include <Pieces/Piece.h>
namespace Alice
{

  /** defines a heuristic ordering  on moves.
   */
  class FullMoveComp//:public std::greater<SmartPointer<Move> >
  {
  public:
    FullMoveComp(const Board& board): mBoard(board){};
    bool operator()(SmartPointer<Move> move1,
		    SmartPointer<Move> move2)
    {
      if (mBoard.at(move1->destination())->isNull())
	return false;
      if (mBoard.at(move2->destination())->isNull())
	return true;
      
      if(mBoard.at(move1->source())->basicValue() <
	 mBoard.at(move2->source())->basicValue())
	return true;
      return (mBoard.at(move1->destination())->basicValue() >
	      mBoard.at(move2->destination())->basicValue());
    }
  private:
    const Board& mBoard;
  };
}; // namespace Alice
# endif // FullMoveComp_h
