//-*-c++-*-
/***************************************************************************
                          Color.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

# ifndef Color_h
# define Color_h
namespace Alice
{
  namespace Representation
  {
    class Color
    {
    public:
      virtual ~Color();
      virtual bool isWhite() const = 0;
      virtual bool isBlack() const = 0;
      virtual Color* otherColor() const = 0;
      static Color* white();
      static Color* black();
      static Color* noColor();
    protected:
      Color();
      static Color* mWhite;
      static Color* mBlack;
      static Color* mNoColor;
    };
    
    inline
    Color*
    Color::white()
    {
      return mWhite;
    };
    
    inline
    Color*
    Color::black()
    {
      return mBlack;
    };
  }; // namespace Representation
  using namespace Representation;
}; // namespace Alice
# endif // Color_h
