//-*-c++-*-
/***************************************************************************
                          Board.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

# ifndef Board_h
# define Board_h
# include "BasicBoard.h"
# include <iostream>
namespace Alice
{
  class Piece;
  class Bitboard;
  class Board:
    public BasicBoard<const Piece*>
  {
  public:
    Board();
    ~Board();
    void put(const Piece* p, const Square& sq);
    void clear( const Square& sq );
    bool readForsythe( std::istream& in );
    void writeForsythe( std::ostream& out ) const;
    void writeHtml( std::ostream& out ) const;
    void initialPosition();
    void displayOn( std::ostream& out ) const;
    const Bitboard& getAllPieces() const;
    const Bitboard& getAllPiecesRotated90() const;
    const Bitboard& getAllPiecesRotated45() const;
    const Bitboard& getAllPiecesRotated135() const;
    const Bitboard& getWhitePieces() const;
    const Bitboard& getBlackPieces() const;
    const Bitboard& getWhiteRooks() const;
    const Bitboard& getBlackRooks() const;
    const Bitboard& getWhiteBishops() const;
    const Bitboard& getBlackBishops() const;
    const Bitboard& getWhiteKnights() const;
    const Bitboard& getBlackKnights() const;
    const Bitboard& getWhiteQueens() const;
    const Bitboard& getBlackQueens() const;
    const Bitboard& getWhitePawns() const;
    const Bitboard& getBlackPawns() const;
    const Bitboard& getWhiteKings() const;
    const Bitboard& getBlackKings() const;
    void clear();
    int totalMaterial() const;
  private:
    Board( const Board& );
    Board& operator = ( const Board& );
    void writeForsytheRank( std::ostream& out, int rank ) const;
    void writeForsytheEndOfRank( std::ostream& out, int rank, int free ) const;
    Piece* nullPiece() const;
    Piece* const mNullPiece;
    Bitboard* allPieces;
    Bitboard* allPiecesRotated90;
    Bitboard* allPiecesRotated45;
    Bitboard* allPiecesRotated135;
    Bitboard* whitePieces;
    Bitboard* blackPieces;
    Bitboard* whiteKing;
    Bitboard* whiteQueens;
    Bitboard* whiteRooks;
    Bitboard* whiteBishops;
    Bitboard* whiteKnights;
    Bitboard* whitePawns;
    Bitboard* blackKing;
    Bitboard* blackQueens;
    Bitboard* blackRooks;
    Bitboard* blackBishops;
    Bitboard* blackKnights;
    Bitboard* blackPawns;

  };
}; // namespace Alice

# endif
