// -*- c++ -*-
/***************************************************************************
                          BasicBoard.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# ifndef BasicBoard_h
# define BasicBoard_h

# include <vector>
namespace Alice
{
class Square;

template<class Type, class Square=Alice::Square>
class BasicBoard
{
public:
  BasicBoard();
  const Type& at(const Square& sq) const;
  Type& at(const Square& sq);
  void put(Type p, const Square& sq);
  
  const Type& operator[](const Square& sq) const
  {
    return at( sq);
  };
  Type& operator[](const Square& sq)
  {
    return at( sq);
  };
private:
  std::vector<Type > entries;
  
};

template<class Type, class Square>
BasicBoard<Type, Square>::BasicBoard(): 
  entries(Square::maximalNumber)
{};

template<class Type, class Square> 
inline
void
BasicBoard<Type, Square>::put(Type p, const Square& sq)
{
    entries[sq.number()] = p;
};

template<class Type, class Square>
inline
const Type& 
BasicBoard<Type, Square>::at(const Square& sq) const
{
  return entries[sq.number()];
};
template<class Type, class Square>
inline
Type& 
BasicBoard<Type, Square>::at(const Square& sq)
{
  return entries[sq.number()];
};
}; // namespace Alice   
# endif
