/***************************************************************************
                          QuiescenceSearch.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-
# ifndef QuiescenceSearch_h
# define QuiescenceSearch_h
# include "Algorithms/AlphaBeta.h"
namespace Alice
{
class Game;
class QuiescenceSearch:
  public AlphaBeta
{
public:
  QuiescenceSearch(Game& game, Evaluation* evaluation);
  virtual ~QuiescenceSearch();
  void search(int depth);
  Score recursiveSearch(int depth, Score alpha, Score beta);
  Evaluation* getEvaluation() const;
  void setEvaluation(Evaluation* ev);
protected:
  bool generateMoves(MoveList& moves);
  Score initialScore( Score alpha, Score beta );
  bool staticExchangeEvaluation(const Square& target, Score own, Score other);
  Evaluation* eval;
};
}; // namespace Alice
# endif
