//-*-c++-*-
/***************************************************************************
                          HistoryMoveComp.h  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2003 by Sven Reichard
    email                : sven.reichard@freenet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


# ifndef HistoryMoveComp_h
# define HistoryMoveComp_h
namespace Alice
{
class HistoryMoveComp
{
public:
  HistoryMoveComp(const Board& board,
		  const BasicBoard<BasicBoard<long> >&values)
    : mBoard(board), mValues(values)
  {
    
  };
  bool operator()(SmartPointer<Move> move1,
		  SmartPointer<Move> move2)
  {
    if (mBoard.at(move1->destination())->isNull()){
      if (mBoard.at(move2->destination())->isNull())
	return mValues[move1->source()][ move1->destination()]
	  > mValues[move2->source()][ move2->destination()];
      return false;
      
    }
    if (mBoard.at(move2->destination())->isNull())
      return true;
    Evaluation::Score attacker1(mBoard.at(move1->source())->basicValue());
    Evaluation::Score attacker2(mBoard.at(move2->source())->basicValue());
    Evaluation::Score defender1(mBoard.at(move1->destination())->basicValue());
    Evaluation::Score defender2(mBoard.at(move2->destination())->basicValue());
    attacker1 -= defender1;
    attacker2 -= defender2;
    return attacker1 < attacker2;
  }
private:
  const Board& mBoard;
  const BasicBoard<BasicBoard<long> >& mValues;
};
}; // namespace Alice
# endif // HistoryMoveComp_h
