//-*-c++-*-
/***************************************************************************
                          HistoryAlphaBeta.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
# ifndef HistoryAlphaBeta_h
# define HistoryAlphaBeta_h
# include "Algorithms/HashedAlphaBeta.h"
# include "TranspositionTable/TranspositionTable.h"
namespace Alice
{
class HistoryAlphaBeta:
  public HashedAlphaBeta
{
public:
  HistoryAlphaBeta(Game& game);
  virtual ~HistoryAlphaBeta();
  void printInfo();
  void setGame(Game& g);
private:
  bool generateMoves(MoveList& moves);
  void processCutOff(int depth, Score result, 
		     SmartPointer<Move> bestMove);
  void failHigh(int depth, Score score,
			SmartPointer<Move> bestMove);
  BasicBoard<BasicBoard<long> > historyValues;
};
}; // namespace Alice
# endif // HashedAlphaBeta
