/***************************************************************************
                          AlphaBetaWithQSearch.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Sven Reichard
    email                : reichard@math.udel.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//-*-c++-*-
# ifndef AlphaBetaWithQSearch_h
# define AlphaBetaWithQSearch_h
# include "Algorithms/AlphaBeta.h"
# include "Algorithms/QuiescenceSearch.h"
namespace Alice
{
class Game;
class QuiescenceSearch;
/** Search algorithm.
 * The problem with fixed depth search is that the leaf positions
 * where the static evaluation is applied can have tactical
 * features such as hanging pieces or pending exchanges.
 * This algorithm circumvents those problems by searching for
 * "quiescent" position before evaluating, i.e., positions
 * that are more accurately to evaluate.
 *
 * It attempts to perform all reasonable exchanges and to
 * capture all hanging pieces before the evaluation function
 * is applied.
 */
class AlphaBetaWithQSearch:
  public AlphaBeta
{
public:
  AlphaBetaWithQSearch(Game& game);
  virtual ~AlphaBetaWithQSearch();
  virtual long nodesSearched() {return mNodesSearched + qsearch->nodesSearched();};
  void setEvaluation(Evaluation* eval);
  Evaluation* getEvaluation() const;
  void setGame(Game& g);
protected:
  virtual Score staticEvaluation(Score alpha, Score beta);
  Evaluation* eval;
  QuiescenceSearch* qsearch;
  virtual void presearch();
 private:
};
}; // namespace Alice
# endif // AlphaBetaWithQSearch_h
