# include <fstream>
# include <vector>
# include <iostream>
int main(void)
{
  std::ofstream file("boards.ps");
  file << "%!PS-Adobe-3.0 EPSF-3.0"<<std::endl;
  file << "%%BoundingBox: 0 0 800 800"<<std::endl;
  
  file << "/box"<<std::endl;
  file << "{"<<std::endl;
  file << "    0 20 rlineto"<<std::endl;
  file << "    20 0 rlineto"<<std::endl;
  file << "    0 -20 rlineto"<<std::endl;
  file << "    closepath"<<std::endl;
  file << "} def"<<std::endl;
  
  std::ifstream valueFile("piecePlacement");
  for (int k = 0; k < 6; k++)
    {
      std::vector<double> values(64);
      for (int i = 0; i < 64; i++)
	valueFile >> values[i];
      double min = values[0];
      double max = values[0];
      for (std::vector<double>::const_iterator it = values.begin();
	   it != values.end(); ++ it)
	{
	  if (*it > max)
	    max = *it;
	  if (*it < min)
	    min = *it;
	}
      max += .1;
      min -= .1;
      std::cout<<"max: "<<max<<", min: "<<min<<std::endl;
      for (std::vector<double>::iterator it = values.begin();
	   it !=  values.end();
	   ++ it)
	{
	  *it = (*it+-min)/(max-min);
	  if (*it < 0)
	    *it = 0;
	  if (*it > 1)
	    *it = 1;
	}
      for (int i = 0; i < 8; i++)
	for (int j = 0; j < 8; j++)
	  {
	    
	    file << "newpath"<<std::endl;
	    int l = k/2;
	    int p = k%2;
	    file << "    "<<l* 200 + i*20<<" "<<p*200 + j*20<<" moveto"<<std::endl;
	    file << "    box"<<std::endl;
	    file << "    "<<values[i*8+j]<<" setgray"<<std::endl;
	    file << "    fill"<<std::endl;
	    
	  }
    }
      file << "showpage"<<std::endl;
  return 0;
};
