# include <Perft.h>
# include <Game/Game.h>
# include <iostream>
# include <cstdlib>
# include <CpuTimer.h>
int main(int argc, char* argv[])
{
  using namespace Alice;
  int maxDepth = 4;
  if (argc > 1)
    maxDepth = std::atoi(argv[1]);
  Game g;
  //g.forsytheString("r3k2r/p1ppqpb1/bn2pnp1/3PN3/1p2P3/2N2Q1p/PPPBBPPP/R3K2R/w");
  for (int depth = 1; depth <= maxDepth; depth ++)
    {
      std::cout<<"--- depth "<<depth<<std::endl;
      Perft perft( g, depth );
      CpuTimer timer;
      perft.search();
      double seconds = timer.age();
      long totalNodes = 0;
      for (int i = 0; i <= depth; i++)
	{
	  std::cout<<i<<": "<<perft.getNodesAtDepth(i)<<std::endl;
	  totalNodes += perft.getNodesAtDepth(i);
	}
      std::cout<<std::endl;
      std::cout<<"time taken: "<<seconds<<" sec"<<std::endl;
      std::cout<<"total nodes: "<<totalNodes<<"; ";
      if (seconds > 1e-6)
	std::cout<<"nodes per seconds: "<<totalNodes/seconds;
      std::cout<<std::endl;
      if (depth > 1)
	{
	  double branching = perft.getNodesAtDepth(depth);
	  branching /= perft.getNodesAtDepth(depth-1);
	  std::cout<<"branching factor: "<<branching<<std::endl;
	  std::cout<<"expected time for next iteration: "
		   <<seconds * branching<<" seconds"<<std::endl;
	}
      std::cout<<std::endl;
    }
};
