# include <Game/Game.h>
# include <Game/PositionalEvaluation.h>
# include <TestData/TestPositionSuite.h>
# include <cmath>
# include <fstream>
using namespace Alice;

int main(void)
{
  std::ofstream learnLog("learn.log", std::ios_base::app);
  TestPositionSuite suite("position.epd");
  learnLog<<"found "<<suite.numberOfPositions()<<" positions"<<std::endl;
  PositionalEvaluation eval;
  std::vector<Evaluation::Score> scores(suite.numberOfPositions());
  eval.computeScores( suite, scores );
  std::cout<<scores[0]<<" "<<scores[1]<<std::endl;
  Evaluation::Score error = eval.totalError( scores );
  learnLog<<"total error: "<<error<<std::endl;
  eval.adjustWeights(suite,scores);
  eval.computeScores(suite, scores);
  learnLog<<"total error now: "<<eval.totalError(scores)<<std::endl;
  return 0;
}
