# include <Board.h>
# include <Pieces/Piece.h>
# include <Square.h>
# include <Moves/Move.h>
typedef signed char distance;

distance distances[2][64][64][64];
int illegalPositions=0;
const signed char ILLEGAL=-1;
const signed char DRAW=-2;
const signed char UNKNOWN=-3;

Alice::Board board;
void initialize()
{
  for (int color = 0; color < 2; color ++)
    for (int whiteKing = 0; whiteKing < 64; whiteKing++)
      for (int blackKing = 0; blackKing < 64; blackKing ++)
	for (int whiteRook = 0; whiteRook < 64; whiteRook ++)
	  {
	    if ((whiteKing == blackKing) ||
		(whiteKing == whiteRook) ||
		(blackKing == whiteRook))
	      {
		distances[color][whiteKing][blackKing][whiteRook] = ILLEGAL;
		illegalPositions++;
	      }
	    else
	      distances[color][whiteKing][blackKing][whiteRook] = UNKNOWN;
	  }
};


void 
findFirst()
{
  
    for (int whiteKing = 0; whiteKing < 64; whiteKing++)
      for (int blackKing = 0; blackKing < 64; blackKing ++)
	for (int whiteRook = 0; whiteRook < 64; whiteRook ++)
	  {
	    if (distances[0][whiteKing][blackKing][whiteRook] == ILLEGAL)
	      continue;
	    std::cout<<whiteKing<<" "<<blackKing<<" "<<whiteRook<<std::endl;
	    Alice::Square wk(whiteKing>>3, whiteKing&7);
	    Alice::Square bk(blackKing>>3, blackKing&7);
	    Alice::Square wr(whiteRook>>3, whiteRook&7);
	    board[wk] = Alice::Piece::newKing(Alice::Color::white());
	    board[bk] = Alice::Piece::newKing(Alice::Color::black());
	    board[wr] = Alice::Piece::newRook(Alice::Color::white());
	    board.displayOn(std::cout);
	    Alice::MoveList moves;
	    board[wk]->pseudolegalMoves(moves, wk, board, false);
	    for (Alice::MoveList::const_iterator it = moves.begin();
		 it != moves.end(); ++ it)
	      (*it)->printOn(std::cout);
	    std::cout<<std::endl;
	    return;
	  }
};

int main()
{
  initialize();
  std::cout<<"illegal positions: "<<illegalPositions<<std::endl;
  findFirst();
  return 0;
};
