# include <Algorithms/HistoryAlphaBeta.h>
# include <TestData/TestPositionSuite.h>
# include <Game/Game.h>
# include <cassert>
# include <Moves/SanNotation.h>
# include <Game/PositionalEvaluation.h>
# include <ctime>
# include <cstdlib>
using namespace Alice;
void
printFullPV( HashedAlphaBeta& algo, Game& g, int maxDepth,
	     Evaluation* eval)
{
  std::vector<SmartPointer<Move> > pv;
  for (int depth = maxDepth; depth > 0;)
    {
      algo.search(depth);
      if (! algo.bestMove())
	break;
      pv.push_back(algo.bestMove());
      SanNotation san(pv.back(), g);
      pv.back()->makeOn(g);
      depth = algo.nextDepth(depth);
    }
  QuiescenceSearch qsearch(g, eval);
  for(;;)
    {
      QuiescenceSearch qsearch(g, eval);
      qsearch.search(100);
      if (!qsearch.bestMove())
	break;
      pv.push_back(qsearch.bestMove());
      qsearch.bestMove()->makeOn(g);
    };
  for (int i = pv.size()-1; i >=0; i--)
    pv[i]->takeBackOn(g);
  for (int i = 0; i < pv.size(); i++)
    {

      SanNotation san(pv[i], g);
      std::cout<<san<<" ";
      pv[i]->makeOn(g);

    };
  for (int i = pv.size()-1; i >= 0; i--)
    pv[i]->takeBackOn(g);
  std::cout<<std::endl;
}

int main(int argc, char* argv[])
{
  std::srand(std::time(0));
  using namespace Alice;
  assert(argc > 1);
  TestPositionSuite suite(argv[1]);
  assert(suite.numberOfPositions() > 0);
  
  TestPosition position(suite.getPosition(4));
  Game g;
  g.forsytheString(position.forsythe());
  g.board().displayOn(std::cout);
  //if (position.getColorToMove() == "b")
  /// g.doNullMove();
  HistoryAlphaBeta algo(g);
  PositionalEvaluation* eval = new PositionalEvaluation;
  eval->startObserving(&g);
  algo.setEvaluation(eval);
  algo.printCompletePV(5);
};
